package gov.va.med.mhv.usermgmt.data.repository;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.mhv.usermgmt.data.model.Allergies;

@Repository
public interface AllergiesRepository extends JpaRepository<Allergies, Long> {

	@Query("select distinct a.allergy from Allergies a where a.userProfileId = :userProfileId order by a.allergy")
	List<String> getAllergiesForUser(@Param("userProfileId") Long userProfileId);
}
